	function msd = genmsdcoeffs(val, w, signed)
	%msd = genmsdcoeffs(val, w, signed)
	
	%Copyright 2008, 2010 Anton Blad
	%
	%This file is part of firgen.
	%
	%firgen is free software: you can redistribute it and/or modify
	%it under the terms of the GNU General Public License as published by
	%the Free Software Foundation, either version 3 of the License, or
	%(at your option) any later version.
	%
	%firgen is distributed in the hope that it will be useful,
	%but WITHOUT ANY WARRANTY; without even the implied warranty of
	%MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	%GNU General Public License for more details.
	%
	%You should have received a copy of the GNU General Public License
	%along with firgen.  If not, see <http://www.gnu.org/licenses/>
	
	bin1s = sum(dectobin(val, w, signed));
	
	ireps = genmsdcoeffs_int(val, bin1s);
	
	sd1s = sum(abs(ireps), 2);
	
	min1s = min(sd1s);
	
	msd = ireps(sd1s == min1s, :);
	
	if size(msd, 2) > w
		if sum(sum(msd(:, 1:end-w))) > 0
			error 'genreps: increase w'
		else
			msd = msd(:, end-w+1:end);
		end
	elseif size(msd, 2) < w
		msd = [zeros(size(msd, 1), w-size(msd, 2)) msd];
	end
	
